/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.graphics;

public class ColorYIQ {
    private double y;
    public static double MIN_Y = 0.0;
    public static double MAX_Y = 1.0;
    private double i;
    public static double MAX_I = 0.5957;
    private double q;
    public static double MAX_Q = 0.5226;

    public ColorYIQ(double y, double i, double q, boolean scale) {
        if (scale) {
            y *= MAX_Y;
            i *= MAX_I;
            q *= MAX_Q;
        }
        this.y = ColorYIQ.normalize(y, MIN_Y, MAX_Y);
        this.i = ColorYIQ.normalize(i, -MAX_I, MAX_I);
        this.q = ColorYIQ.normalize(q, -MAX_Q, MAX_Q);
    }

    public ColorYIQ(double y, double i, double q) {
        this(y, i, q, true);
    }

    public static int getR(int rgb) {
        int r = rgb >> 16 & 0xFF;
        return r;
    }

    public static int getG(int rgb) {
        int g = rgb >> 8 & 0xFF;
        return g;
    }

    public static int getB(int rgb) {
        int b = rgb & 0xFF;
        return b;
    }

    public static ColorYIQ fromRGB(int rgb) {
        return ColorYIQ.fromRGB(ColorYIQ.getR(rgb), ColorYIQ.getG(rgb), ColorYIQ.getB(rgb));
    }

    public static ColorYIQ fromRGB(int r, int g, int b) {
        double R = (double)r / 255.0;
        double G = (double)g / 255.0;
        double B = (double)b / 255.0;
        double Y = 0.299 * R + 0.587 * G + 0.114 * B;
        double I = 0.596 * R - 0.275 * G - 0.321 * B;
        double Q = 0.212 * R - 0.523 * G + 0.311 * B;
        return new ColorYIQ(Y, I, Q, false);
    }

    public int toRGB() {
        int r = (int)(ColorYIQ.normalize(this.y + 0.956 * this.i + 0.621 * this.q, 0.0, 1.0) * 255.0);
        int g = (int)(ColorYIQ.normalize(this.y - 0.272 * this.i - 0.647 * this.q, 0.0, 1.0) * 255.0);
        int b = (int)(ColorYIQ.normalize(this.y - 1.105 * this.i + 1.702 * this.q, 0.0, 1.0) * 255.0);
        return r << 16 | g << 8 | b;
    }

    double distanceWeighted(ColorYIQ search) {
        int c1 = this.toRGB();
        int c2 = search.toRGB();
        double r = (double)(ColorYIQ.getR(c1) + ColorYIQ.getR(c2)) / 2.0;
        double g = ColorYIQ.getG(c1) - ColorYIQ.getG(c2);
        double b = ColorYIQ.getB(c1) - ColorYIQ.getB(c2);
        double distance = Math.pow((2.0 + r / 256.0) * r * r + 4.0 * g * g + (2.0 + (255.0 - r) / 256.0) * b * b, -2.0);
        return distance;
    }

    public double distance(ColorYIQ search) {
        double distY = Math.pow(Math.abs(search.y - this.y), 2.0) / MAX_Y;
        double distI = Math.pow(Math.abs(search.i - this.i), 2.0) / MAX_I;
        double distQ = Math.pow(Math.abs(search.q - this.q), 2.0) / MAX_Q;
        double yiqDistance = Math.abs(Math.pow(distY + distI + distQ, -2.0));
        return yiqDistance;
    }

    public static double normalize(double x, double minX, double maxX) {
        if (x < minX) {
            return minX;
        }
        if (x > maxX) {
            return maxX;
        }
        return x;
    }
}

